/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.managed;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.HwmcaObjectProvider;
import com.ibm.hwmca.fw.managed.ManagedObjectTree;
import com.ibm.hwmca.fw.managed.ManagedObjectTreeListener;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.ProviderMethods;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.WeakValueHashMap;
import com.ibm.hwmca.fw.util.WorkEvent;
import com.ibm.hwmca.fw.util.WorkListener;
import com.ibm.hwmca.fw.util.WorkPerformer;
import com.ibm.hwmca.fw.util.WorkThread;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ManagedObjectManager
implements ProviderMethods {
    public static final String INVENTORY_PROPERTY = "InventoryProperty";
    private Map _inventory = Collections.synchronizedMap(new HashMap());
    private Map _listeners = Collections.synchronizedMap(new HashMap());
    private Map _fullaccess = Collections.synchronizedMap(new HashMap());
    private Map _skipPermission = Collections.synchronizedMap(new HashMap());
    private Map _providers = Collections.synchronizedMap(new HashMap());
    private WeakValueHashMap _weakRefInventory = new WeakValueHashMap();
    private static final String TRACE_MASKT = "XMOM   T";
    private static final String TRACE_MASKF = "XMOM   F";
    private static final String TRACE_MASKD = "XMOM   D";
    private static final String ADD = "ADD";
    private static final String REMOVE = "REMOVE";
    private static final String INITIAL = "INITIAL";
    private ObjectId _objectId = null;
    private Worker _worker;
    private static ManagedObjectManager _mom = new ManagedObjectManager();
    private FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "MOM");

    private ManagedObjectManager() {
        Trace.trace(TRACE_MASKT, " <> ManagedObjectManager.ManagedObjectManager()");
        this._objectId = new ObjectId(this);
        this._worker = new Worker();
    }

    public static ManagedObjectManager getManagedObjectManager() {
        Trace.trace(TRACE_MASKT, " <> ManagedObjectManager.getManagedObjectManager()");
        return _mom;
    }

    public ObjectId getObjectId() {
        return this._objectId;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.addPropertyChangeListener(listener, false);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener, boolean initialEvent) {
        ClassId classId = new ClassId("com.ibm.hwmca.fw.managed", "HwmcaObject");
        ClassId[] classIds = new ClassId[]{classId};
        this.addPropertyChangeListener(listener, initialEvent, classIds);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener, boolean initialEvent, ClassId classId) {
        ClassId[] classIds = new ClassId[]{classId};
        this.addPropertyChangeListener(listener, initialEvent, classIds);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener, boolean initialEvent, ClassId[] classIds) {
        Set ids;
        Trace.trace(TRACE_MASKT, " -> ManagedObjectManager.addPropertyChangeListener(listener=" + listener + " initialEvent=" + initialEvent + " classIds=" + classIds + ")");
        if (listener == null) {
            throw new NullPointerException("null listener specified");
        }
        ListenerInfo info = new ListenerInfo(listener, UserContext.getCurrentUserContext(), classIds);
        this._listeners.put(listener, info);
        if (initialEvent && !(ids = this.getInventoryObjectIds(classIds)).isEmpty()) {
            Object[] parms = new Object[]{ids, INITIAL, listener};
            this._worker.requestWork(INITIAL, parms);
        }
        Trace.trace(TRACE_MASKT, " <- ManagedObjectManager.addPropertyChangeListener()");
    }

    public synchronized void addPropertyChangeListener(ObjectId id, String propertyName, PropertyChangeListener listener, boolean registerObjects) {
        Trace.trace(TRACE_MASKT, " -> ManagedObjectManager.addPropertyChangeListener(listener=" + listener + " objectId=" + id + " propertyName=" + propertyName + " registerObjects=" + registerObjects + ")");
        if (listener == null) {
            throw new NullPointerException("null listener specified");
        }
        HwmcaObject obj = null;
        obj = (HwmcaObject)this._inventory.get(id);
        if (obj != null) {
            obj.addPropertyChangeListener(propertyName, listener);
        } else {
            Trace.trace(TRACE_MASKF, " object not found in the inventory...see if it has a provider");
            HwmcaObjectProvider provider = this.getProvider(id.getClassId());
            if (provider != null) {
                obj = this.getReferencedObject(id);
                if (obj != null) {
                    obj.addPropertyChangeListener(propertyName, listener);
                } else {
                    provider.addPropertyChangeListener(id, propertyName, listener);
                }
            }
        }
        Trace.trace(TRACE_MASKT, " <- ManagedObjectManager.addPropertyChangeListener()");
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        Trace.trace(TRACE_MASKT, " <> ManagedObjectManager.removePropertyChangeListener(listener=" + listener + ")");
        if (listener == null) {
            throw new NullPointerException("null listener specified");
        }
        ListenerInfo info = (ListenerInfo)this._listeners.remove(listener);
        if (info == null) {
            Trace.trace(TRACE_MASKF, "could not find listener " + listener + " in the list");
        }
    }

    public synchronized void removePropertyChangeListener(ObjectId id, String propertyName, PropertyChangeListener listener) {
        Trace.trace(TRACE_MASKT, " -> ManagedObjectManager.removePropertyChangeListener(listener=" + listener + " objectId=" + id + ")");
        if (listener == null) {
            throw new NullPointerException("null listener specified");
        }
        HwmcaObject obj = null;
        obj = (HwmcaObject)this._inventory.get(id);
        if (obj != null) {
            obj.removePropertyChangeListener(propertyName, listener);
        } else {
            Trace.trace(TRACE_MASKF, " object not found in the inventory...see if it has a provider");
            HwmcaObjectProvider provider = this.getProvider(id.getClassId());
            if (provider != null) {
                obj = this.getReferencedObject(id);
                if (obj != null) {
                    obj.removePropertyChangeListener(propertyName, listener);
                } else {
                    provider.removePropertyChangeListener(id, propertyName, listener);
                }
            }
        }
        Trace.trace(TRACE_MASKT, " <- ManagedObjectManager.removePropertyChangeListener()");
    }

    public void addProvider(HwmcaObjectProvider provider, ClassId classId) {
        ArrayList<ClassId> classIds = new ArrayList<ClassId>();
        classIds.add(classId);
        this.addProvider(provider, classIds);
    }

    public void addProvider(HwmcaObjectProvider provider, Collection classIds) {
        Trace.trace(TRACE_MASKT, " <> ManagedObjectManager.addProvider(provider=" + provider + " classIds=" + classIds + ")");
        if (provider == null) {
            throw new NullPointerException("null provider specified");
        }
        Iterator i = classIds.iterator();
        while (i.hasNext()) {
            ClassId classId = (ClassId)i.next();
            if (this._providers.containsKey(classId)) {
                throw new IllegalStateException("Provider already added for classId=" + classId);
            }
            this._providers.put(classId, provider);
        }
    }

    public void removeProvider(HwmcaObjectProvider provider) {
        Trace.trace(TRACE_MASKT, " <> ManagedObjectManager.removeProvider(provider=" + provider + ")");
        if (provider == null) {
            throw new NullPointerException("null provider specified");
        }
        HwmcaObjectProvider objProvider = (HwmcaObjectProvider)this._providers.remove(provider);
        if (objProvider == null) {
            Trace.trace(TRACE_MASKF, "could not find provider " + provider + " in the list");
        }
    }

    public void addSkipPermission(ClassId id) throws NullPointerException, IllegalStateException {
        if (id == null) {
            throw new NullPointerException("null id specified");
        }
        UserContext userContext = UserContext.getCurrentUserContext();
        if (userContext != null) {
            if (userContext.getType() != 3) {
                throw new IllegalStateException("Non-SYSTEM UserContext type found");
            }
        } else {
            throw new IllegalStateException("null UserContext found");
        }
        Trace.trace(TRACE_MASKF, "skipping permission checking for " + id);
        this._skipPermission.put(id, null);
    }

    public void removeSkipPermission(ClassId id) throws NullPointerException, IllegalStateException {
        if (id == null) {
            throw new NullPointerException("null id specified");
        }
        UserContext userContext = UserContext.getCurrentUserContext();
        if (userContext != null) {
            if (userContext.getType() != 3) {
                throw new IllegalStateException("Non-SYSTEM UserContext type found");
            }
        } else {
            throw new IllegalStateException("null UserContext found");
        }
        Trace.trace(TRACE_MASKF, "now checking permissions for " + id);
        this._skipPermission.remove(id);
    }

    public void addFullAccessMethod(String classname, String methodname) throws NullPointerException, IllegalStateException {
        if (methodname == null) {
            throw new NullPointerException("null method name specified");
        }
        if (classname == null) {
            throw new NullPointerException("null class name specified");
        }
        UserContext userContext = UserContext.getCurrentUserContext();
        if (userContext != null) {
            if (userContext.getType() != 3) {
                throw new IllegalStateException("Non-SYSTEM UserContext type found");
            }
        } else {
            throw new IllegalStateException("null UserContext found");
        }
        Trace.trace(TRACE_MASKF, "adding full access for " + classname + "#" + methodname + ".");
        this._fullaccess.put(classname + "#" + methodname, null);
    }

    public void removeFullAccessMethod(String classname, String methodname) throws NullPointerException, IllegalStateException {
        if (methodname == null) {
            throw new NullPointerException("null method name specified");
        }
        if (classname == null) {
            throw new NullPointerException("null class name specified");
        }
        UserContext userContext = UserContext.getCurrentUserContext();
        if (userContext != null) {
            if (userContext.getType() != 3) {
                throw new IllegalStateException("Non-SYSTEM UserContext type found");
            }
        } else {
            throw new IllegalStateException("null UserContext found");
        }
        Trace.trace(TRACE_MASKF, "removing full access for " + classname + "#" + methodname + ".");
        this._fullaccess.remove(classname + "#" + methodname);
    }

    private boolean isPermitted(User user, ObjectId objectId) {
        boolean bPermit = false;
        bPermit = this._skipPermission.containsKey(objectId);
        if (bPermit) {
            Trace.trace(TRACE_MASKD, "permission checking not required for " + objectId);
        } else {
            bPermit = this._skipPermission.containsKey(objectId.getClassId());
            if (bPermit) {
                Trace.trace(TRACE_MASKD, "permission checking not required for " + objectId.getClassId());
            } else if (user.isObjectPermitted(objectId)) {
                Trace.trace(TRACE_MASKD, "user has permission for the object");
                bPermit = true;
            } else {
                Trace.trace(TRACE_MASKD, "user does not have permission for the object");
                StackTraceElement[] elements = new Throwable().getStackTrace();
                if (elements.length > 2 && (bPermit = this._fullaccess.containsKey(elements[2].getClassName() + "#" + elements[2].getMethodName()))) {
                    Trace.trace(TRACE_MASKD, "calling method (" + elements[2].getClassName() + "#" + elements[2].getMethodName() + ") has full access permission");
                }
            }
        }
        return bPermit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HwmcaObject myGetObject(ObjectId id) {
        Trace.trace(TRACE_MASKD, " -> ManagedObjectManager.myGetObject(objectId=" + id + ")");
        HwmcaObject obj = null;
        obj = (HwmcaObject)this._inventory.get(id);
        if (obj == null) {
            Trace.trace(TRACE_MASKF, " object not found in the inventory");
            if (this._providers.containsKey(id.getClassId()) && (obj = this.getReferencedObject(id)) == null) {
                Trace.trace(TRACE_MASKF, " provided object not found in the weak reference inventory");
                HwmcaObjectProvider provider = (HwmcaObjectProvider)this._providers.get(id.getClassId());
                if (provider != null) {
                    obj = provider.get(id);
                    WeakValueHashMap weakValueHashMap = this._weakRefInventory;
                    synchronized (weakValueHashMap) {
                        this._weakRefInventory.put(id, obj);
                    }
                }
            }
        }
        Trace.trace(TRACE_MASKD, " <- ManagedObjectManager.myGetObject()");
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set myGetInventoryObjs(ClassId classId) {
        Trace.trace(TRACE_MASKD, " -> ManagedObjectManager.myGetInventoryObjs(classId=" + classId + ")");
        HashSet<HwmcaObject> objs = new HashSet<HwmcaObject>();
        try {
            Class<?> theClass = Class.forName(classId.getFullClassName());
            Map map = this._inventory;
            synchronized (map) {
                Iterator i = this._inventory.values().iterator();
                while (i.hasNext()) {
                    HwmcaObject obj = (HwmcaObject)i.next();
                    if (!obj.getObjectId().isInstanceOf(theClass)) continue;
                    objs.add(obj);
                }
            }
        }
        catch (ClassNotFoundException exc) {
            HException hexc = new HException(exc);
            new FrameworkLog(this._logInfo, 2457, hexc).log();
        }
        Trace.trace(TRACE_MASKD, " <- ManagedObjectManager.myGetInventoryObjs()");
        return objs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set myGetInventoryObjIds(ClassId classId) {
        Trace.trace(TRACE_MASKD, " -> ManagedObjectManager.myGetInventoryObjIds(classId=" + classId + ")");
        HashSet<ObjectId> ids = new HashSet<ObjectId>();
        try {
            Class<?> theClass = Class.forName(classId.getFullClassName());
            Map map = this._inventory;
            synchronized (map) {
                Iterator i = this._inventory.keySet().iterator();
                while (i.hasNext()) {
                    ObjectId id = (ObjectId)i.next();
                    if (!id.isInstanceOf(theClass)) continue;
                    ids.add(id);
                }
            }
        }
        catch (ClassNotFoundException exc) {
            HException hexc = new HException(exc);
            new FrameworkLog(this._logInfo, 2458, hexc).log();
        }
        Trace.trace(TRACE_MASKD, " <- ManagedObjectManager.myGetInventoryObjIds()");
        return ids;
    }

    private boolean isObjectInstanceOf(ObjectId id, ClassId[] classIds) {
        boolean bMatch = false;
        try {
            for (int x = 0; x < classIds.length; ++x) {
                if (id.isInstanceOf(Class.forName(classIds[x].getFullClassName()))) {
                    bMatch = true;
                }
                if (!bMatch) {
                    continue;
                }
                break;
            }
        }
        catch (ClassNotFoundException exc) {
            HException hexc = new HException(exc);
            new FrameworkLog(this._logInfo, 2459, hexc).log();
        }
        return bMatch;
    }

    boolean isObjectAllowed(ObjectId id) {
        return this.isObjectAllowed(id, UserContext.getCurrentUserContext());
    }

    boolean isObjectAllowed(ObjectId id, UserContext userContext) {
        boolean bAllow = false;
        if (userContext == null) {
            throw new IllegalStateException("null UserContext found");
        }
        if (userContext.isAuthenticated()) {
            User user = User.getUser(userContext.getUserid());
            if (user != null && this.isPermitted(user, id)) {
                bAllow = true;
            }
        } else {
            bAllow = true;
        }
        return bAllow;
    }

    private Set getAllowedObjects(Collection objs, boolean usingIds) {
        return this.getAllowedObjects(objs, usingIds, UserContext.getCurrentUserContext());
    }

    private Set getAllowedObjects(Collection objs, boolean usingIds, UserContext userContext) {
        Trace.trace(TRACE_MASKD, " -> ManagedObjectManager.getAllowedObjects()");
        HashSet<Persistable> allowedObjs = new HashSet<Persistable>();
        if (userContext == null) {
            throw new IllegalStateException("null UserContext found");
        }
        if (userContext.isAuthenticated()) {
            User user = User.getUser(userContext.getUserid());
            if (user != null) {
                Iterator i = objs.iterator();
                while (i.hasNext()) {
                    if (usingIds) {
                        ObjectId id = (ObjectId)i.next();
                        if (!this.isPermitted(user, id)) continue;
                        allowedObjs.add(id);
                        continue;
                    }
                    HwmcaObject obj = (HwmcaObject)i.next();
                    if (!this.isPermitted(user, obj.getObjectId())) continue;
                    allowedObjs.add(obj);
                }
            }
        } else {
            Trace.trace(TRACE_MASKD, " userContext is not authenticated...all objects are allowed.");
            allowedObjs.addAll(objs);
        }
        Trace.trace(TRACE_MASKD, " <- ManagedObjectManager.getAllowedObjects()");
        return allowedObjs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HwmcaObjectProvider getProvider(ClassId classId) {
        Trace.trace(TRACE_MASKD, " -> ManagedObjectManager.getProvider(classId=" + classId + ")");
        HwmcaObjectProvider provider = null;
        Map map = this._providers;
        synchronized (map) {
            if (this._providers.containsKey(classId)) {
                provider = (HwmcaObjectProvider)this._providers.get(classId);
            } else {
                Trace.trace(TRACE_MASKF, " no provider found for classId, return null");
            }
        }
        Trace.trace(TRACE_MASKD, " <- ManagedObjectManager.getProvider()");
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToWeakRefInventory(Set objs) {
        Trace.trace(TRACE_MASKD, " -> ManagedObjectManager.addToWeakRefInventory()");
        WeakValueHashMap weakValueHashMap = this._weakRefInventory;
        synchronized (weakValueHashMap) {
            Iterator i = objs.iterator();
            while (i.hasNext()) {
                HwmcaObject obj = (HwmcaObject)i.next();
                if (obj == null) {
                    throw new NullPointerException("object is null");
                }
                ObjectId id = obj.getObjectId();
                if (this._weakRefInventory.containsKey(id)) continue;
                this._weakRefInventory.put(id, obj);
            }
        }
        Trace.trace(TRACE_MASKD, " <- ManagedObjectManager.addToWeakRefInventory()");
    }

    public HwmcaObject get(ObjectId id) {
        Trace.trace(TRACE_MASKT, " <> ManagedObjectManager.get(objectId=" + id + ")");
        HwmcaObject obj = null;
        if (this.isObjectAllowed(id)) {
            obj = this.myGetObject(id);
        }
        return obj;
    }

    public Set getInventory() {
        ClassId classId = new ClassId("com.ibm.hwmca.fw.managed", "HwmcaObject");
        ClassId[] classIds = new ClassId[]{classId};
        return this.getInventory(classIds);
    }

    public Set getInventory(ClassId classId) {
        ClassId[] classIds = new ClassId[]{classId};
        return this.getInventory(classIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getInventory(ClassId[] classIds) {
        Trace.trace(TRACE_MASKT, " -> ManagedObjectManager.getInventory(ClassIds=" + classIds + ")");
        HashSet inv = new HashSet();
        HashSet providers = null;
        Map map = this._providers;
        synchronized (map) {
            providers = new HashSet(this._providers.values());
        }
        Iterator i = providers.iterator();
        while (i.hasNext()) {
            HwmcaObjectProvider provider = (HwmcaObjectProvider)i.next();
            Set objs = provider.getInventory(classIds);
            if (objs.isEmpty()) continue;
            inv.addAll(objs);
            this.addToWeakRefInventory(objs);
        }
        for (int x = 0; x < classIds.length; ++x) {
            inv.addAll(this.myGetInventoryObjs(classIds[x]));
        }
        Set allowedObjs = this.getAllowedObjects(inv, false);
        Trace.trace(TRACE_MASKT, " <- ManagedObjectManager.getInventory()");
        return allowedObjs;
    }

    public Set getInventoryObjectIds() {
        ClassId classId = new ClassId("com.ibm.hwmca.fw.managed", "HwmcaObject");
        ClassId[] classIds = new ClassId[]{classId};
        return this.getInventoryObjectIds(classIds);
    }

    public Set getInventoryObjectIds(ClassId classId) {
        ClassId[] classIds = new ClassId[]{classId};
        return this.getInventoryObjectIds(classIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getInventoryObjectIds(ClassId[] classIds) {
        Trace.trace(TRACE_MASKT, " -> ManagedObjectManager.getInventoryObjectIds(ClassIds=" + classIds + ")");
        HashSet ids = new HashSet();
        HashSet providers = null;
        Map map = this._providers;
        synchronized (map) {
            providers = new HashSet(this._providers.values());
        }
        Iterator i = providers.iterator();
        while (i.hasNext()) {
            HwmcaObjectProvider provider = (HwmcaObjectProvider)i.next();
            ids.addAll(provider.getInventoryObjectIds(classIds));
        }
        for (int x = 0; x < classIds.length; ++x) {
            ids.addAll(this.myGetInventoryObjIds(classIds[x]));
        }
        Set allowedObjs = this.getAllowedObjects(ids, true);
        Trace.trace(TRACE_MASKT, " <- ManagedObjectManager.getInventoryObjectIds()");
        return allowedObjs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedObjectTree getManagedObjectTree(ClassId[] classIds) {
        Trace.trace(TRACE_MASKT, " -> ManagedObjectManager.getManagedObjectTree(ClassIds=" + classIds + ")");
        ManagedObjectTree tree = null;
        Map map = this._inventory;
        synchronized (map) {
            tree = classIds == null || classIds.length == 0 ? new ManagedObjectTree(this._objectId, this.getInventoryObjectIds()) : new ManagedObjectTree(this._objectId, this.getInventoryObjectIds(classIds));
        }
        Trace.trace(TRACE_MASKT, " <- ManagedObjectManager.getManagedObjectTree()");
        return tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addManagedObjectTreeListener(ClassId[] classIds, ManagedObjectTreeListener listener, boolean initialEvent) {
        Trace.trace(TRACE_MASKT, " -> ManagedObjectManager.addManagedObjectTreeListener(ClassIds=" + classIds + ")");
        ManagedObjectTree tree = new ManagedObjectTree(this._objectId, listener);
        Map map = this._inventory;
        synchronized (map) {
            Set ids;
            this._listeners.put(tree, new ListenerInfo(tree, UserContext.getCurrentUserContext(), classIds));
            if (initialEvent && !(ids = this.getInventoryObjectIds(classIds)).isEmpty()) {
                Object[] parms = new Object[]{ids, INITIAL, tree};
                this._worker.requestWork(INITIAL, parms);
            }
        }
        Trace.trace(TRACE_MASKT, " <- ManagedObjectManager.addManagedObjectTreeListener()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set getInventoryObjects() {
        Trace.trace(TRACE_MASKT, " -> ManagedObjectManager.getInventoryObjects()");
        HashSet inv = new HashSet();
        Map map = this._inventory;
        synchronized (map) {
            inv.addAll(this._inventory.values());
        }
        Set classIdsSet = this._providers.keySet();
        ClassId[] classIds = new ClassId[classIdsSet.size()];
        int x = 0;
        Iterator i = classIdsSet.iterator();
        while (i.hasNext()) {
            classIds[x] = (ClassId)i.next();
            x = (short)(x + 1);
        }
        HashSet providers = null;
        Map map2 = this._providers;
        synchronized (map2) {
            providers = new HashSet(this._providers.values());
        }
        Iterator i2 = providers.iterator();
        while (i2.hasNext()) {
            HwmcaObjectProvider provider = (HwmcaObjectProvider)i2.next();
            Set objs = provider.getInventory(classIds);
            if (objs.isEmpty()) continue;
            inv.addAll(objs);
            this.addToWeakRefInventory(objs);
        }
        Trace.trace(TRACE_MASKT, " <- ManagedObjectManager.getInventoryObjects()");
        return inv;
    }

    Set getInventoryObjects(ClassId classId) {
        ClassId[] classIds = new ClassId[]{classId};
        return this.getInventoryObjects(classIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set getInventoryObjects(ClassId[] classIds) {
        Trace.trace(TRACE_MASKT, " -> ManagedObjectManager.getInventoryObjects(ClassIds = " + classIds + ")");
        HashSet inv = new HashSet();
        for (int x = 0; x < classIds.length; ++x) {
            inv.addAll(this.myGetInventoryObjs(classIds[x]));
        }
        HashSet providers = null;
        Map map = this._providers;
        synchronized (map) {
            providers = new HashSet(this._providers.values());
        }
        Iterator i = providers.iterator();
        while (i.hasNext()) {
            HwmcaObjectProvider provider = (HwmcaObjectProvider)i.next();
            Set objs = provider.getInventory(classIds);
            if (objs.isEmpty()) continue;
            inv.addAll(objs);
            this.addToWeakRefInventory(objs);
        }
        Trace.trace(TRACE_MASKT, " <- ManagedObjectManager.getInventoryObjects()");
        return inv;
    }

    HwmcaObject getObject(ObjectId id) {
        Trace.trace(TRACE_MASKT, " <> ManagedObjectManager.getObject(objectId" + id + ")");
        return this.myGetObject(id);
    }

    public Object getProperty(ObjectId id, String propertyName) {
        Object result = null;
        String[] properties = new String[]{propertyName};
        Map propertyMap = this.getProperties(id, properties);
        if (propertyMap != null) {
            result = propertyMap.get(propertyName);
        }
        return result;
    }

    public Map getProperties(ObjectId id, String[] propertyNames) {
        Trace.trace(TRACE_MASKT, " -> ManagedObjectManager.getProperties(ObjectId=" + id + "propertyNames=" + propertyNames + ")");
        HwmcaObject obj = null;
        Map properties = null;
        ReflectiveOperationException exception = null;
        try {
            if (this.isObjectAllowed(id)) {
                obj = (HwmcaObject)this._inventory.get(id);
                if (obj != null) {
                    properties = obj.getProperties(propertyNames);
                } else {
                    Trace.trace(TRACE_MASKF, " object not found in the inventory...see if it has a provider");
                    HwmcaObjectProvider provider = this.getProvider(id.getClassId());
                    if (provider != null) {
                        obj = this.getReferencedObject(id);
                        properties = obj != null ? obj.getProperties(propertyNames) : provider.getProperties(id, propertyNames);
                    }
                }
            }
        }
        catch (NoSuchMethodException exc) {
            exception = exc;
        }
        catch (InvocationTargetException exc) {
            exception = exc;
        }
        if (exception != null) {
            HException hexc = new HException(exception);
            new FrameworkLog(this._logInfo, 2460, hexc).log();
        }
        Trace.trace(TRACE_MASKT, " <- ManagedObjectManager.getProperties()");
        return properties;
    }

    public Object[] getProperties(ObjectId id, String[] propertyNames, Object[] propertyValues) {
        Trace.trace(TRACE_MASKT, " -> ManagedObjectManager.getProperties(ObjectId=" + id + ",propertyNames=" + propertyNames + ", Object[])");
        HwmcaObject obj = null;
        Map properties = null;
        ReflectiveOperationException exception = null;
        try {
            if (this.isObjectAllowed(id)) {
                obj = (HwmcaObject)this._inventory.get(id);
                if (obj != null) {
                    properties = obj.getProperties(propertyNames);
                } else {
                    Trace.trace(TRACE_MASKF, " object not found in the inventory...see if it has a provider");
                    HwmcaObjectProvider provider = this.getProvider(id.getClassId());
                    if (provider != null) {
                        obj = this.getReferencedObject(id);
                        if (obj != null) {
                            properties = obj.getProperties(propertyNames);
                        } else {
                            propertyValues = provider.getProperties(id, propertyNames, propertyValues);
                        }
                    }
                }
            }
        }
        catch (NoSuchMethodException exc) {
            exception = exc;
        }
        catch (InvocationTargetException exc) {
            exception = exc;
        }
        if (exception != null) {
            HException hexc = new HException(exception);
            new FrameworkLog(this._logInfo, 2460, hexc).log();
        }
        if (properties != null) {
            for (int i = 0; i < propertyNames.length; ++i) {
                propertyValues[i] = properties.get(propertyNames[i]);
            }
        }
        Trace.trace(TRACE_MASKT, " <- ManagedObjectManager.getProperties()");
        return propertyValues;
    }

    public void setProperty(ObjectId id, String propertyName, Object newValue) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(propertyName, newValue);
        this.setProperties(id, properties);
    }

    public void setProperties(ObjectId id, Map properties) {
        Trace.trace(TRACE_MASKT, " -> ManagedObjectManager.setProperties(ObjectId=" + id + "properties=" + properties + ")");
        HwmcaObject obj = null;
        ReflectiveOperationException exception = null;
        try {
            if (this.isObjectAllowed(id)) {
                obj = (HwmcaObject)this._inventory.get(id);
                if (obj != null) {
                    obj.setProperties(properties);
                } else {
                    Trace.trace(TRACE_MASKF, " object not found in the inventory...see if it has a provider");
                    HwmcaObjectProvider provider = this.getProvider(id.getClassId());
                    if (provider != null) {
                        obj = this.getReferencedObject(id);
                        if (obj != null) {
                            obj.setProperties(properties);
                        } else {
                            provider.setProperties(id, properties);
                        }
                    }
                }
            }
        }
        catch (NoSuchMethodException exc) {
            exception = exc;
        }
        catch (InvocationTargetException exc) {
            exception = exc;
        }
        if (exception != null) {
            HException hexc = new HException(exception);
            new FrameworkLog(this._logInfo, 2461, hexc).log();
        }
        Trace.trace(TRACE_MASKT, " <- ManagedObjectManager.setProperties()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getListeners() {
        ArrayList collection;
        Map map = this._listeners;
        synchronized (map) {
            collection = new ArrayList(this._listeners.values());
        }
        Trace.trace(TRACE_MASKD, " number of listeners = " + collection.size());
        return collection;
    }

    private void processListeners(Collection objectIds, String action) {
        ArrayList listeners = this.getListeners();
        HashMap<UserContext, Set> allowedObjsByUserContext = new HashMap<UserContext, Set>();
        int listenersSize = listeners.size();
        for (int i = 0; i < listenersSize; ++i) {
            ListenerInfo info = (ListenerInfo)listeners.get(i);
            PropertyChangeListener listener = info.getListener();
            UserContext uc = info.getUserContext();
            ClassId[] classIds = info.getClassIds();
            Set allowedObjs = (Set)allowedObjsByUserContext.get(uc);
            if (allowedObjs == null) {
                allowedObjs = this.getAllowedObjects(objectIds, true, uc);
                allowedObjsByUserContext.put(uc, allowedObjs);
            }
            ArrayList<ObjectId> ids = new ArrayList<ObjectId>();
            Iterator j = allowedObjs.iterator();
            while (j.hasNext()) {
                ObjectId id = (ObjectId)j.next();
                if (!this.isObjectInstanceOf(id, classIds)) continue;
                ids.add(id);
            }
            if (ids.isEmpty()) continue;
            Object[] parms = new Object[]{ids, action, listener};
            this._worker.requestWork(action, parms);
        }
    }

    public synchronized void add(HwmcaObject obj) {
        ArrayList<HwmcaObject> objs = new ArrayList<HwmcaObject>();
        objs.add(obj);
        this.add(objs);
    }

    public synchronized void add(Collection objs) {
        Trace.trace(TRACE_MASKT, " -> ManagedObjectManager.add(objs=" + objs + ")");
        ArrayList<ObjectId> ids = new ArrayList<ObjectId>();
        Iterator i = objs.iterator();
        while (i.hasNext()) {
            HwmcaObject obj = (HwmcaObject)i.next();
            if (obj == null) {
                throw new NullPointerException("object is null");
            }
            ObjectId id = obj.getObjectId();
            if (this._inventory.containsKey(id)) {
                throw new UnsupportedOperationException("object is already in the inventory for ObjectId=" + id);
            }
            this._inventory.put(id, obj);
            ids.add(id);
        }
        if (!ids.isEmpty()) {
            this.processListeners(ids, ADD);
        }
        Trace.trace(TRACE_MASKT, " <- ManagedObjectManager.add()");
    }

    public synchronized void remove(ObjectId id) {
        ArrayList<ObjectId> ids = new ArrayList<ObjectId>();
        ids.add(id);
        this.remove(ids);
    }

    public synchronized void remove(Collection objectIds) {
        Trace.trace(TRACE_MASKT, " -> ManagedObjectManager.remove(objectIds=" + objectIds + ")");
        ArrayList<ObjectId> ids = new ArrayList<ObjectId>();
        Iterator i = objectIds.iterator();
        while (i.hasNext()) {
            ObjectId id = (ObjectId)i.next();
            HwmcaObject obj = (HwmcaObject)this._inventory.get(id);
            if (obj == null) {
                Trace.trace(TRACE_MASKF, " object not found in the inventory for ObjectId=" + id);
                continue;
            }
            ids.add(id);
            this._inventory.remove(id);
        }
        if (!ids.isEmpty()) {
            this.processListeners(ids, REMOVE);
        }
        Trace.trace(TRACE_MASKT, " <- ManagedObjectManager.remove()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HwmcaObject getReferencedObject(ObjectId id) {
        Trace.trace(TRACE_MASKT, " -> ManagedObjectManager.getReferencedObject(ObjectId=" + id + ")");
        HwmcaObject obj = null;
        WeakValueHashMap weakValueHashMap = this._weakRefInventory;
        synchronized (weakValueHashMap) {
            obj = (HwmcaObject)this._weakRefInventory.get(id);
            if (obj == null) {
                Trace.trace(TRACE_MASKF, " object not found for ObjectId=" + id + ")");
            }
        }
        Trace.trace(TRACE_MASKT, " <- ManagedObjectManager.getReferencedObject()");
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReferencedObject(ObjectId id) {
        Trace.trace(TRACE_MASKT, " -> ManagedObjectManager.removeReferencedObject(ObjectId=" + id + ")");
        WeakValueHashMap weakValueHashMap = this._weakRefInventory;
        synchronized (weakValueHashMap) {
            HwmcaObject obj = (HwmcaObject)this._weakRefInventory.remove(id);
            if (obj == null) {
                Trace.trace(TRACE_MASKF, " object not found for ObjectId=" + id + ")");
            }
        }
        Trace.trace(TRACE_MASKT, " <- ManagedObjectManager.removeReferencedObject()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReferencedObject(Collection objectIds) {
        Trace.trace(TRACE_MASKT, " -> ManagedObjectManager.removeReferencedObject(objectIds=" + objectIds + ")");
        WeakValueHashMap weakValueHashMap = this._weakRefInventory;
        synchronized (weakValueHashMap) {
            Iterator i = objectIds.iterator();
            while (i.hasNext()) {
                ObjectId id = (ObjectId)i.next();
                HwmcaObject obj = (HwmcaObject)this._weakRefInventory.remove(id);
                if (obj != null) continue;
                Trace.trace(TRACE_MASKF, " object not found for ObjectId=" + id + ")");
            }
        }
        Trace.trace(TRACE_MASKT, " <- ManagedObjectManager.removeReferencedObject()");
    }

    public synchronized void fireInventoryAdd(ObjectId id) {
        this.fireInventoryAdd(Collections.singletonList(id));
    }

    public synchronized void fireInventoryAdd(Collection ids) {
        Trace.trace(TRACE_MASKT, " <> ManagedObjectManager.fireInventoryAdd(ids=" + ids + ")");
        if (!ids.isEmpty()) {
            this.processListeners(ids, ADD);
        }
    }

    public synchronized void fireInventoryRemove(ObjectId id) {
        this.fireInventoryRemove(Collections.singletonList(id));
    }

    public synchronized void fireInventoryRemove(Collection ids) {
        Trace.trace(TRACE_MASKT, " <> ManagedObjectManager.fireInventoryRemove(ids=" + ids + ")");
        if (!ids.isEmpty()) {
            this.processListeners(ids, REMOVE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpInventory() {
        Object set;
        Trace.trace(TRACE_MASKF, "Dump the inventory...");
        Map map = this._inventory;
        synchronized (map) {
            set = this._inventory.keySet();
            Iterator i = set.iterator();
            while (i.hasNext()) {
                String s = ((ObjectId)i.next()).toString();
                Trace.trace(TRACE_MASKF, "  " + s);
            }
        }
        Trace.trace(TRACE_MASKF, "Dump the providers...");
        HashSet providers = null;
        set = this._providers;
        synchronized (set) {
            providers = new HashSet(this._providers.values());
        }
        Iterator i = providers.iterator();
        while (i.hasNext()) {
            String s = ((HwmcaObjectProvider)i.next()).toString();
            Trace.trace(TRACE_MASKF, "  " + s);
        }
        Trace.trace(TRACE_MASKF, "End of inventory dump");
    }

    private static class ListenerInfo {
        private PropertyChangeListener _listener;
        private UserContext _userContext;
        private ClassId[] _classIds;

        public ListenerInfo(PropertyChangeListener listener, UserContext userContext, ClassId[] classIds) {
            this._listener = listener;
            this._userContext = userContext;
            this._classIds = classIds;
        }

        public PropertyChangeListener getListener() {
            return this._listener;
        }

        public UserContext getUserContext() {
            return this._userContext;
        }

        public ClassId[] getClassIds() {
            return this._classIds;
        }
    }

    private class Worker
    implements WorkPerformer,
    WorkListener {
        private WorkThread _workThread = new WorkThread("MOM event notification thread");

        public Worker() {
            this._workThread.startWorker();
        }

        public void requestWork(String action, Object[] inParms) {
            this._workThread.requestWork(this, this, action, inParms);
        }

        public Object performWork(Object inParms) throws Throwable {
            Trace.trace(ManagedObjectManager.TRACE_MASKT, " -> Worker.performWork()");
            Object[] parms = (Object[])inParms;
            Object[] ids = ((Collection)parms[0]).toArray();
            String action = (String)parms[1];
            PropertyChangeListener listener = (PropertyChangeListener)parms[2];
            ObjectId[] evtIds = new ObjectId[ids.length];
            int j = 0;
            for (int i = 0; i < ids.length; ++i) {
                evtIds[j++] = (ObjectId)ids[i];
            }
            Trace.trace(ManagedObjectManager.TRACE_MASKF, "About to fire " + action + " event to PropertyChangeListener " + listener);
            if (action.equals(ManagedObjectManager.INITIAL) || action.equals(ManagedObjectManager.ADD)) {
                listener.propertyChange(new PropertyChangeEvent(ManagedObjectManager.this.getObjectId(), ManagedObjectManager.INVENTORY_PROPERTY, null, evtIds));
            } else {
                listener.propertyChange(new PropertyChangeEvent(ManagedObjectManager.this.getObjectId(), ManagedObjectManager.INVENTORY_PROPERTY, evtIds, null));
            }
            Trace.trace(ManagedObjectManager.TRACE_MASKT, " <- Worker.performWork()");
            return null;
        }

        public void workCompleted(WorkEvent event) {
            Trace.trace(ManagedObjectManager.TRACE_MASKT, " <> Worker.workCompleted()");
            if (event.hasException()) {
                HException hexc = new HException(event.getException());
                new FrameworkLog(ManagedObjectManager.this._logInfo, 2448, hexc).log();
            }
        }
    }
}

